/*********************************************************************************************************//**
 * @file    BCH.h
 * @version $Rev:: 5827         $
 * @date    $Date:: 2022-08-30 #$
 * @brief   The header file of the RF library.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/

/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef __BCH_H__
#define __BCH_H__

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------------------------*/
#include "ht32.h"
#include	"bc3603.h"

/** @addtogroup HT32F67232_Peripheral_Driver HT32F67232 Peripheral Driver
  * @{
  */

/** @addtogroup RF
  * @{
  */


/* Exported constants --------------------------------------------------------------------------*/
/** @defgroup RF_Exported_Constants RF exported constants
  * @{
  */

/* BCH(16,11,4,t1) Barker 7, support 2^(11-(7-1))=  32 devices		*/
#define BCH_16_N					16
#define BCH_16_K					11
#define BCH_16_BARKER_LEN   	7		//32
#define LAP_16_K              (BCH_16_K - BCH_16_BARKER_LEN + 1) 
/* BCH(32,26, 4,t1) Barker  7, support 2^(26-( 7-1))= 1,048,576 devices	*/
#define BCH_32_N					32
#define BCH_32_K					26
#define BCH_32_BARKER_LEN    	7						//1,048,576
#define LAP_32_K         		(BCH_32_K - BCH_32_BARKER_LEN + 1)

#define BARKER_PAD_0        	((u32)0x0000002C)
#define BARKER_PAD_1        	((u32)0x00000013)

/**
  * @}
  */


/* Exported types ------------------------------------------------------------------------------------------*/
/** @defgroup RF_Exported_Types RF exported types
  * @{
  */

/**
  * @}
  */


/* Exported functions --------------------------------------------------------------------------------------*/
/** @defgroup RF_Exported_Functions RF exported functions
  * @{
  */  

/**
  * @}
  */
void BCH_SyncwordCalculate(RF_SYNCLEN_Enum SNL, u8 *lap, u8 *pIdcode);

/**
  * @}
  */

/**
  * @}
  */

#ifdef __cplusplus
}
#endif

#endif
